/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.chunk_rendering;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3532;
import net.minecraft.class_4548;
import net.minecraft.class_631;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_631.class})
public abstract class MixinClientChunkManager
implements ChunkStatusListenerManager {
    private final LongOpenHashSet loadedChunks = new LongOpenHashSet();
    private ChunkStatusListener listener;

    @Shadow
    @Nullable
    public abstract class_2818 method_2857(int var1, int var2, class_2806 var3, boolean var4);

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;resetChunkColor(II)V", shift=At.Shift.AFTER)})
    private void afterLoadChunkFromPacket(int x, int z, class_4548 biomes, class_2540 buf, class_2487 tag, int verticalStripBitmask, boolean complete, CallbackInfoReturnable<class_2818> cir) {
        if (this.listener != null) {
            this.listener.onChunkAdded(x, z);
            this.loadedChunks.add(class_1923.method_8331((int)x, (int)z));
        }
    }

    @Inject(method={"unload"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientChunkManager$ClientChunkMap;compareAndSet(ILnet/minecraft/world/chunk/WorldChunk;Lnet/minecraft/world/chunk/WorldChunk;)Lnet/minecraft/world/chunk/WorldChunk;", shift=At.Shift.AFTER)})
    private void afterUnloadChunk(int x, int z, CallbackInfo ci) {
        if (this.listener != null) {
            this.listener.onChunkRemoved(x, z);
            this.loadedChunks.remove(class_1923.method_8331((int)x, (int)z));
        }
    }

    @Inject(method={"updateLoadDistance"}, at={@At(value="RETURN")})
    private void afterLoadDistanceChanged(int loadDistance, CallbackInfo ci) {
        LongIterator it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            int z;
            long pos = it.nextLong();
            int x = class_1923.method_8325((long)pos);
            if (this.method_2857(x, z = class_1923.method_8332((long)pos), class_2806.field_12803, false) != null) continue;
            it.remove();
            if (this.listener == null) continue;
            this.listener.onChunkRemoved(x, z);
        }
    }

    @Override
    public void setListener(ChunkStatusListener listener) {
        this.listener = listener;
    }

    @Mixin(targets={"net/minecraft/client/world/ClientChunkManager$ClientChunkMap"})
    public static class MixinClientChunkMap {
        @Mutable
        @Shadow
        @Final
        private AtomicReferenceArray<class_2818> field_16251;
        @Mutable
        @Shadow
        @Final
        private int field_16252;
        @Mutable
        @Shadow
        @Final
        private int field_16253;
        private int factor;

        @Inject(method={"<init>"}, at={@At(value="RETURN")})
        private void reinit(class_631 outer, int loadDistance, CallbackInfo ci) {
            this.field_16253 = loadDistance;
            this.field_16252 = class_3532.method_15339((int)(loadDistance * 2 + 1));
            this.factor = this.field_16252 - 1;
            this.field_16251 = new AtomicReferenceArray(this.field_16252 * this.field_16252);
        }

        @Overwrite
        private int method_16027(int chunkX, int chunkZ) {
            return (chunkZ & this.factor) * this.field_16252 + (chunkX & this.factor);
        }
    }
}

