/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_852;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderContainer<T> render;
    private final class_2338 offset;
    private final ChunkRenderContext context;

    public ChunkRenderRebuildTask(ChunkRenderContainer<T> render, ChunkRenderContext context, class_2338 offset) {
        this.render = render;
        this.offset = offset;
        this.context = context;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        class_852 occluder = new class_852();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init(renderData);
        cache.init(this.context);
        WorldSlice slice = cache.getWorldSlice();
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338 renderOffset = this.offset;
        for (int relY = 0; relY < 16; ++relY) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int relX = 0; relX < 16; ++relX) {
                    class_827 renderer;
                    class_2586 entity;
                    class_3610 fluidState;
                    class_2680 blockState = slice.getBlockStateRelative(relX + 16, relY + 16, relZ + 16);
                    if (blockState.method_26215()) continue;
                    pos.method_10103(baseX + relX, baseY + relY, baseZ + relZ);
                    buffers.setRenderOffset(pos.method_10263() - renderOffset.method_10263(), pos.method_10264() - renderOffset.method_10264(), pos.method_10260() - renderOffset.method_10260());
                    if (blockState.method_26217() == class_2464.field_11458) {
                        buffers.setMaterialId(blockState, (short)-1);
                        class_1921 layer = class_4696.method_23679((class_2680)blockState);
                        class_1087 model = cache.getBlockModels().method_3335(blockState);
                        long seed = blockState.method_26190((class_2338)pos);
                        if (cache.getBlockRenderer().renderModel(slice, blockState, (class_2338)pos, model, buffers.get(layer), true, seed)) {
                            bounds.addBlock(relX, relY, relZ);
                        }
                        buffers.resetMaterialId();
                    }
                    if (!(fluidState = blockState.method_26227()).method_15769()) {
                        buffers.setMaterialId(fluidState.method_15759(), (short)1);
                        class_1921 layer = class_4696.method_23680((class_3610)fluidState);
                        if (cache.getFluidRenderer().render(slice, fluidState, (class_2338)pos, buffers.get(layer))) {
                            bounds.addBlock(relX, relY, relZ);
                        }
                        buffers.resetMaterialId();
                    }
                    if (blockState.method_26204().method_26161() && (entity = slice.method_8321((class_2338)pos)) != null && (renderer = class_824.field_4346.method_3550(entity)) != null) {
                        renderData.addBlockEntity(entity, !renderer.method_3563(entity));
                        bounds.addBlock(relX, relY, relZ);
                    }
                    if (!blockState.method_26216((class_1922)slice, (class_2338)pos)) continue;
                    occluder.method_3682((class_2338)pos);
                }
            }
        }
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
        }
        renderData.setOcclusionData(occluder.method_3679());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    @Override
    public void releaseResources() {
        this.context.releaseResources();
    }
}

