/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.compat.LegacyFogHelper;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderBindingPoints;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkRenderShaderBackend<T extends ChunkGraphicsState>
implements ChunkRenderBackend<T> {
    private final EnumMap<ChunkFogMode, EnumMap<BlockRenderPass, ChunkProgram>> programs = new EnumMap(ChunkFogMode.class);
    private final EnumMap<ChunkFogMode, EnumMap<BlockRenderPass, ChunkProgram>> shadowPrograms = new EnumMap(ChunkFogMode.class);
    @Nullable
    private final SodiumTerrainPipeline pipeline = SodiumTerrainPipeline.create().orElse(null);
    protected final ChunkVertexType vertexType;
    protected final GlVertexFormat<ChunkMeshAttribute> vertexFormat;
    protected ChunkProgram activeProgram;

    public ChunkRenderShaderBackend(ChunkVertexType vertexType) {
        this.vertexType = vertexType;
        this.vertexFormat = vertexType.getCustomVertexFormat();
    }

    private GlShader createVertexShader(RenderDevice device, ChunkFogMode fogMode, BlockRenderPass pass, boolean shadow) {
        if (this.pipeline != null) {
            Optional irisVertexShader;
            if (shadow) {
                irisVertexShader = this.pipeline.getShadowVertexShaderSource();
            } else {
                Optional optional = irisVertexShader = pass.isTranslucent() ? this.pipeline.getTranslucentVertexShaderSource() : this.pipeline.getTerrainVertexShaderSource();
            }
            if (irisVertexShader.isPresent()) {
                return new GlShader(device, ShaderType.VERTEX, new class_2960("iris", "sodium-terrain.vsh"), (String)irisVertexShader.get(), ShaderConstants.builder().build());
            }
        }
        return ShaderLoader.loadShader(device, ShaderType.VERTEX, new class_2960("sodium", "chunk_gl20.v.glsl"), fogMode.getDefines());
    }

    private GlShader createFragmentShader(RenderDevice device, ChunkFogMode fogMode, BlockRenderPass pass, boolean shadow) {
        if (this.pipeline != null) {
            Optional irisFragmentShader;
            if (shadow) {
                irisFragmentShader = this.pipeline.getShadowFragmentShaderSource();
            } else {
                Optional optional = irisFragmentShader = pass.isTranslucent() ? this.pipeline.getTranslucentFragmentShaderSource() : this.pipeline.getTerrainFragmentShaderSource();
            }
            if (irisFragmentShader.isPresent()) {
                return new GlShader(device, ShaderType.FRAGMENT, new class_2960("iris", "sodium-terrain.fsh"), (String)irisFragmentShader.get(), ShaderConstants.builder().build());
            }
        }
        return ShaderLoader.loadShader(device, ShaderType.FRAGMENT, new class_2960("sodium", "chunk_gl20.f.glsl"), fogMode.getDefines());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkProgram createShader(RenderDevice device, ChunkFogMode fogMode, BlockRenderPass pass, GlVertexFormat<ChunkMeshAttribute> vertexFormat, boolean shadow) {
        GlShader vertShader = this.createVertexShader(device, fogMode, pass, shadow);
        GlShader fragShader = this.createFragmentShader(device, fogMode, pass, shadow);
        try {
            ChunkProgram chunkProgram = GlProgram.builder(new class_2960("sodium", "chunk_shader_for_" + pass.toString().toLowerCase(Locale.ROOT) + (shadow ? "_gbuffer" : "_shadow"))).attachShader(vertShader).attachShader(fragShader).bindAttribute("a_Pos", ChunkShaderBindingPoints.POSITION).bindAttribute("a_Color", ChunkShaderBindingPoints.COLOR).bindAttribute("a_TexCoord", ChunkShaderBindingPoints.TEX_COORD).bindAttribute("a_LightCoord", ChunkShaderBindingPoints.LIGHT_COORD).bindAttribute("mc_Entity", ChunkShaderBindingPoints.BLOCK_ID).bindAttribute("mc_midTexCoord", ChunkShaderBindingPoints.MID_TEX_COORD).bindAttribute("at_tangent", ChunkShaderBindingPoints.TANGENT).bindAttribute("a_Normal", ChunkShaderBindingPoints.NORMAL).bindAttribute("d_ModelOffset", ChunkShaderBindingPoints.MODEL_OFFSET).build((program, name) -> {
                ProgramUniforms uniforms = null;
                if (this.pipeline != null) {
                    uniforms = this.pipeline.initUniforms(name);
                }
                return new ChunkProgram(device, program, name, fogMode.getFactory(), uniforms);
            });
            return chunkProgram;
        }
        finally {
            vertShader.delete();
            fragShader.delete();
        }
    }

    @Override
    public final void createShaders(RenderDevice device) {
        for (ChunkFogMode fogMode : ChunkFogMode.values()) {
            this.programs.put(fogMode, this.createShadersForFogMode(device, fogMode, false));
            this.shadowPrograms.put(fogMode, this.createShadersForFogMode(device, fogMode, true));
        }
    }

    private EnumMap<BlockRenderPass, ChunkProgram> createShadersForFogMode(RenderDevice device, ChunkFogMode mode, boolean shadow) {
        EnumMap<BlockRenderPass, ChunkProgram> shaders = new EnumMap<BlockRenderPass, ChunkProgram>(BlockRenderPass.class);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            shaders.put(pass, this.createShader(device, mode, pass, this.vertexFormat, shadow));
        }
        return shaders;
    }

    @Override
    public void begin(class_4587 matrixStack, BlockRenderPass pass) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            this.activeProgram = this.shadowPrograms.get((Object)LegacyFogHelper.getFogMode()).get((Object)pass);
            RenderSystem.disableCull();
        } else {
            this.activeProgram = this.programs.get((Object)LegacyFogHelper.getFogMode()).get((Object)pass);
        }
        this.activeProgram.bind();
        this.activeProgram.setup(matrixStack, this.vertexType.getModelScale(), this.vertexType.getTextureScale());
    }

    @Override
    public void end(class_4587 matrixStack) {
        this.activeProgram.unbind();
        this.activeProgram = null;
    }

    @Override
    public void delete() {
        for (EnumMap<BlockRenderPass, ChunkProgram> shaders : this.programs.values()) {
            for (ChunkProgram shader : shaders.values()) {
                shader.delete();
            }
        }
        for (EnumMap<BlockRenderPass, ChunkProgram> shaders : this.shadowPrograms.values()) {
            for (ChunkProgram shader : shaders.values()) {
                shader.delete();
            }
        }
    }

    @Override
    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }
}

