/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import java.nio.FloatBuffer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.GameRendererContext;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.texunits.TextureUnit;
import net.minecraft.class_1159;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;

public class ChunkProgram
extends GlProgram {
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale;
    private final int uTextureScale;
    private final int uBlockTex = this.getUniformLocation("u_BlockTex");
    private final int uLightTex = this.getUniformLocation("u_LightTex");
    private final int modelViewMatrixOffset;
    private final int normalMatrixOffset;
    @Nullable
    private final ProgramUniforms irisProgramUniforms;
    private final ChunkShaderFogComponent fogShader;

    protected ChunkProgram(RenderDevice owner, class_2960 name, int handle, Function<ChunkProgram, ChunkShaderFogComponent> fogShaderFunction, @Nullable ProgramUniforms irisProgramUniforms) {
        super(owner, name, handle);
        this.uModelScale = this.getUniformLocation("u_ModelScale");
        this.uTextureScale = this.getUniformLocation("u_TextureScale");
        this.modelViewMatrixOffset = this.getUniformLocation("u_ModelViewMatrix");
        this.normalMatrixOffset = this.getUniformLocation("u_NormalMatrix");
        this.irisProgramUniforms = irisProgramUniforms;
        this.fogShader = fogShaderFunction.apply(this);
    }

    public void setup(class_4587 matrixStack, float modelScale, float textureScale) {
        GL20C.glUniform1i((int)this.uBlockTex, (int)TextureUnit.TERRAIN.getSamplerId());
        GL20C.glUniform1i((int)this.uLightTex, (int)TextureUnit.LIGHTMAP.getSamplerId());
        GL20C.glUniform3f((int)this.uModelScale, (float)modelScale, (float)modelScale, (float)modelScale);
        GL20C.glUniform2f((int)this.uTextureScale, (float)textureScale, (float)textureScale);
        this.fogShader.setup();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            GL20C.glUniformMatrix4fv((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)GameRendererContext.getModelViewProjectionMatrix(matrixStack.method_23760(), memoryStack));
        }
        if (this.irisProgramUniforms != null) {
            this.irisProgramUniforms.update();
        }
        class_1159 modelViewMatrix = matrixStack.method_23760().method_23761();
        class_1159 normalMatrix = matrixStack.method_23760().method_23761().method_22673();
        normalMatrix.method_22870();
        normalMatrix.method_22871();
        this.uniformMatrix(this.modelViewMatrixOffset, modelViewMatrix);
        this.uniformMatrix(this.normalMatrixOffset, normalMatrix);
    }

    @Override
    public int getUniformLocation(String name) {
        try {
            return super.getUniformLocation(name);
        }
        catch (NullPointerException e) {
            System.err.println(e.getMessage());
            return -1;
        }
    }

    private void uniformMatrix(int location, class_1159 matrix) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        matrix.method_4932(buffer);
        buffer.rewind();
        GL20C.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)buffer);
    }
}

