/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegion;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import net.minecraft.class_4076;
import org.apache.commons.lang3.Validate;

public class ChunkRegionManager<T extends ChunkGraphicsState> {
    public static final int BUFFER_WIDTH = 8;
    public static final int BUFFER_HEIGHT = 4;
    public static final int BUFFER_LENGTH = 8;
    public static final int BUFFER_SIZE = 256;
    private static final int BUFFER_WIDTH_SH = Integer.bitCount(7);
    private static final int BUFFER_HEIGHT_SH = Integer.bitCount(3);
    private static final int BUFFER_LENGTH_SH = Integer.bitCount(7);
    private final Long2ReferenceOpenHashMap<ChunkRegion<T>> regions = new Long2ReferenceOpenHashMap();
    private final RenderDevice device;

    public ChunkRegionManager(RenderDevice device) {
        this.device = device;
    }

    public ChunkRegion<T> getRegion(int x, int y, int z) {
        return (ChunkRegion)this.regions.get(ChunkRegionManager.getRegionKey(x, y, z));
    }

    public ChunkRegion<T> getOrCreateRegion(int x, int y, int z) {
        long key = ChunkRegionManager.getRegionKey(x, y, z);
        ChunkRegion region = (ChunkRegion)this.regions.get(key);
        if (region == null) {
            region = new ChunkRegion(this.device, 256);
            this.regions.put(key, region);
        }
        return region;
    }

    public static long getRegionKey(int x, int y, int z) {
        return class_4076.method_18685((int)(x >> BUFFER_WIDTH_SH), (int)(y >> BUFFER_HEIGHT_SH), (int)(z >> BUFFER_LENGTH_SH));
    }

    public void delete() {
        for (ChunkRegion region : this.regions.values()) {
            region.deleteResources();
        }
        this.regions.clear();
    }

    public void cleanup() {
        ObjectIterator iterator = this.regions.values().iterator();
        while (iterator.hasNext()) {
            ChunkRegion region = (ChunkRegion)iterator.next();
            if (!region.isArenaEmpty()) continue;
            region.deleteResources();
            iterator.remove();
        }
    }

    public int getAllocatedRegionCount() {
        return this.regions.size();
    }

    static {
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(4));
    }
}

