/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.format.xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.render.chunk.format.DefaultModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.format.MaterialIdHolder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexUtil;
import me.jellysquid.mods.sodium.client.render.chunk.format.xhfp.NormalHelper;
import me.jellysquid.mods.sodium.client.render.chunk.format.xhfp.QuadView;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.minecraft.class_1160;

public class XHFPModelVertexBufferWriterNio
extends VertexBufferWriterNio
implements ModelVertexSink {
    private MaterialIdHolder idHolder;
    private static final int STRIDE = 48;
    int vertexCount = 0;
    float uSum;
    float vSum;
    private QuadView currentQuad = new QuadView();
    private class_1160 normal = new class_1160();

    public XHFPModelVertexBufferWriterNio(VertexBufferView backingBuffer, MaterialIdHolder idHolder) {
        super(backingBuffer, DefaultModelVertexFormats.MODEL_VERTEX_XHFP);
        this.idHolder = idHolder;
    }

    @Override
    public void writeQuad(float x, float y, float z, int color, float u, float v, int light) {
        this.uSum += u;
        this.vSum += v;
        short materialId = this.idHolder.id;
        short renderType = this.idHolder.renderType;
        this.writeQuadInternal(ModelVertexUtil.denormalizeVertexPositionFloatAsShort(x), ModelVertexUtil.denormalizeVertexPositionFloatAsShort(y), ModelVertexUtil.denormalizeVertexPositionFloatAsShort(z), color, ModelVertexUtil.denormalizeVertexTextureFloatAsShort(u), ModelVertexUtil.denormalizeVertexTextureFloatAsShort(v), ModelVertexUtil.encodeLightMapTexCoord(light), materialId, renderType);
    }

    private void writeQuadInternal(short x, short y, short z, int color, short u, short v, int light, short materialId, short renderType) {
        int i = this.writeOffset;
        ++this.vertexCount;
        ByteBuffer buffer = this.byteBuffer;
        buffer.putShort(i, x);
        buffer.putShort(i + 2, y);
        buffer.putShort(i + 4, z);
        buffer.putInt(i + 8, color);
        buffer.putShort(i + 12, u);
        buffer.putShort(i + 14, v);
        buffer.putInt(i + 16, light);
        buffer.putFloat(i + 32, materialId);
        buffer.putFloat(i + 36, renderType);
        buffer.putFloat(i + 40, 0.0f);
        buffer.putFloat(i + 44, 0.0f);
        if (this.vertexCount == 4) {
            short midU = (short)(65536.0f * (this.uSum * 0.25f));
            short midV = (short)(65536.0f * (this.vSum * 0.25f));
            int midTexCoord = midV << 16 | midU;
            buffer.putInt(i + 20, midTexCoord);
            buffer.putInt(i + 20 - 48, midTexCoord);
            buffer.putInt(i + 20 - 96, midTexCoord);
            buffer.putInt(i + 20 - 144, midTexCoord);
            this.vertexCount = 0;
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.currentQuad.buffer = this.byteBuffer;
            this.currentQuad.writeOffset = this.writeOffset;
            NormalHelper.computeFaceNormal(this.normal, this.currentQuad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            buffer.putInt(i + 28, packedNormal);
            buffer.putInt(i + 28 - 48, packedNormal);
            buffer.putInt(i + 28 - 96, packedNormal);
            buffer.putInt(i + 28 - 144, packedNormal);
            float x0 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i - 144));
            float y0 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i + 2 - 144));
            float z0 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i + 4 - 144));
            float x1 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i - 96));
            float y1 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i + 2 - 96));
            float z1 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i + 4 - 96));
            float x2 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i - 48));
            float y2 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i + 2 - 48));
            float z2 = XHFPModelVertexBufferWriterNio.normalizeVertexPositionShortAsFloat(buffer.getShort(i + 4 - 48));
            float edge1x = x1 - x0;
            float edge1y = y1 - y0;
            float edge1z = z1 - z0;
            float edge2x = x2 - x0;
            float edge2y = y2 - y0;
            float edge2z = z2 - z0;
            float u0 = XHFPModelVertexBufferWriterNio.normalizeVertexTextureShortAsFloat(buffer.getShort(i + 12 - 144));
            float v0 = XHFPModelVertexBufferWriterNio.normalizeVertexTextureShortAsFloat(buffer.getShort(i + 14 - 144));
            float u1 = XHFPModelVertexBufferWriterNio.normalizeVertexTextureShortAsFloat(buffer.getShort(i + 12 - 96));
            float v1 = XHFPModelVertexBufferWriterNio.normalizeVertexTextureShortAsFloat(buffer.getShort(i + 14 - 96));
            float u2 = XHFPModelVertexBufferWriterNio.normalizeVertexTextureShortAsFloat(buffer.getShort(i + 12 - 48));
            float v2 = XHFPModelVertexBufferWriterNio.normalizeVertexTextureShortAsFloat(buffer.getShort(i + 14 - 48));
            float deltaU1 = u1 - u0;
            float deltaV1 = v1 - v0;
            float deltaU2 = u2 - u0;
            float deltaV2 = v2 - v0;
            float fdenom = deltaU1 * deltaV2 - deltaU2 * deltaV1;
            float f = (double)fdenom == 0.0 ? 1.0f : 1.0f / fdenom;
            float tangentx = f * (deltaV2 * edge1x - deltaV1 * edge2x);
            float tangenty = f * (deltaV2 * edge1y - deltaV1 * edge2y);
            float tangentz = f * (deltaV2 * edge1z - deltaV1 * edge2z);
            float tcoeff = XHFPModelVertexBufferWriterNio.rsqrt(tangentx * tangentx + tangenty * tangenty + tangentz * tangentz);
            tangentx *= tcoeff;
            tangenty *= tcoeff;
            float bitangentx = f * (-deltaU2 * edge1x + deltaU1 * edge2x);
            float bitangenty = f * (-deltaU2 * edge1y + deltaU1 * edge2y);
            float bitangentz = f * (-deltaU2 * edge1z + deltaU1 * edge2z);
            float bitcoeff = XHFPModelVertexBufferWriterNio.rsqrt(bitangentx * bitangentx + bitangenty * bitangenty + bitangentz * bitangentz);
            float pbitangentx = tangenty * this.normal.method_4947() - (tangentz *= tcoeff) * this.normal.method_4945();
            float pbitangenty = -(tangentx * this.normal.method_4947() - tangentz * this.normal.method_4943());
            float pbitangentz = tangentx * this.normal.method_4943() - tangenty * this.normal.method_4945();
            float dot = (bitangentx *= bitcoeff) * pbitangentx + (bitangenty *= bitcoeff) + pbitangenty + (bitangentz *= bitcoeff) * pbitangentz;
            int tangentW = dot < 0.0f ? -127 : 127;
            int tangent = Norm3b.pack(tangentx, tangenty, tangentz);
            buffer.putInt(i + 24, tangent |= tangentW << 24);
            buffer.putInt(i + 24 - 48, tangent);
            buffer.putInt(i + 24 - 96, tangent);
            buffer.putInt(i + 24 - 144, tangent);
        }
        this.advance();
    }

    private static float normalizeVertexPositionShortAsFloat(short value) {
        return (float)(value & 0xFFFF) * 1.5259022E-5f;
    }

    private static float normalizeVertexTextureShortAsFloat(short value) {
        return (float)(value & 0xFFFF) * 3.0517578E-5f;
    }

    private static float rsqrt(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(value));
    }
}

