/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCacheManager;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.common.util.pool.ReusableObject;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_3508;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_4548;
import net.minecraft.world.level.ColorResolver;

public class WorldSlice
extends ReusableObject
implements class_1920,
class_4543.class_4544 {
    private static final class_2826 EMPTY_SECTION = new class_2826(0);
    private static final int SECTION_BLOCK_LENGTH = 16;
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = class_3532.method_28139((int)2, (int)16) >> 4;
    private static final int BLOCK_LENGTH = 20;
    private static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int TABLE_LENGTH = class_3532.method_15339((int)SECTION_LENGTH);
    private static final int TABLE_BITS = Integer.bitCount(TABLE_LENGTH - 1);
    private static final int CHUNK_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH;
    private static final int SECTION_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH * TABLE_LENGTH;
    private final class_2680[][] blockStatesArrays;
    private final class_2680[] originBlockStates;
    private final class_2804[] blockLightArrays;
    private final class_2804[] skyLightArrays;
    private final BiomeCache[] biomeCaches;
    private final class_4548[] biomeArrays;
    private final Map<ColorResolver, BiomeColorCache> colorResolvers = new Reference2ObjectOpenHashMap();
    private ColorResolver prevColorResolver;
    private BiomeColorCache prevColorCache;
    private class_1937 world;
    private class_2818[] chunks;
    private BiomeCacheManager biomeCacheManager;
    private int baseX;
    private int baseY;
    private int baseZ;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private class_4076 origin;

    public static class_2818[] createChunkSlice(class_1937 world, class_4076 pos) {
        class_2818 chunk = world.method_8497(pos.method_10263(), pos.method_10260());
        class_2826 section = chunk.method_12006()[pos.method_10264()];
        if (section == null || section.method_12261()) {
            return null;
        }
        int minChunkX = pos.method_10263() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = pos.method_10260() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = pos.method_10263() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = pos.method_10260() + NEIGHBOR_CHUNK_RADIUS;
        class_2818[] chunks = new class_2818[CHUNK_TABLE_ARRAY_SIZE];
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                chunks[WorldSlice.getLocalChunkIndex((int)(x - minChunkX), (int)(z - minChunkZ))] = world.method_8497(x, z);
            }
        }
        return chunks;
    }

    public WorldSlice() {
        this.blockStatesArrays = new class_2680[SECTION_TABLE_ARRAY_SIZE][];
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    this.blockStatesArrays[WorldSlice.getLocalSectionIndex((int)x, (int)y, (int)z)] = new class_2680[4096];
                }
            }
        }
        this.blockLightArrays = new class_2804[SECTION_TABLE_ARRAY_SIZE];
        this.skyLightArrays = new class_2804[SECTION_TABLE_ARRAY_SIZE];
        this.biomeCaches = new BiomeCache[CHUNK_TABLE_ARRAY_SIZE];
        this.biomeArrays = new class_4548[CHUNK_TABLE_ARRAY_SIZE];
        this.originBlockStates = this.blockStatesArrays[WorldSlice.getLocalSectionIndex(SECTION_LENGTH / 2, SECTION_LENGTH / 2, SECTION_LENGTH / 2)];
    }

    public void init(ChunkBuilder<?> builder, class_1937 world, class_4076 origin, class_2818[] chunks) {
        this.world = world;
        this.chunks = chunks;
        this.origin = origin;
        this.minX = origin.method_19527() - 2;
        this.minY = origin.method_19528() - 2;
        this.minZ = origin.method_19529() - 2;
        this.maxX = origin.method_19530() + 2;
        this.maxY = origin.method_19531() + 2;
        this.maxZ = origin.method_19532() + 2;
        int minChunkX = this.minX >> 4;
        int minChunkY = this.minY >> 4;
        int minChunkZ = this.minZ >> 4;
        int maxChunkX = this.maxX >> 4;
        int maxChunkY = this.maxY >> 4;
        int maxChunkZ = this.maxZ >> 4;
        this.baseX = minChunkX << 4;
        this.baseY = minChunkY << 4;
        this.baseZ = minChunkZ << 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int chunkIdx = WorldSlice.getLocalChunkIndex(chunkX - minChunkX, chunkZ - minChunkZ);
                class_2818 chunk = this.chunks[chunkIdx];
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    class_4076 pos = class_4076.method_18676((int)chunkX, (int)chunkY, (int)chunkZ);
                    int sectionIdx = WorldSlice.getLocalSectionIndex(chunkX - minChunkX, chunkY - minChunkY, chunkZ - minChunkZ);
                    this.populateLightArrays(sectionIdx, pos);
                    this.populateBlockArrays(sectionIdx, pos, (class_2791)chunk);
                }
                this.biomeArrays[chunkIdx] = chunk.method_12036();
            }
        }
        this.biomeCacheManager = builder.getBiomeCacheManager();
        this.biomeCacheManager.populateArrays(origin.method_10263(), origin.method_10264(), origin.method_10260(), this.biomeCaches);
    }

    private void populateLightArrays(int sectionIdx, class_4076 pos) {
        class_3562 blockLightProvider = this.world.method_22336().method_15562(class_1944.field_9282);
        class_3562 skyLightProvider = this.world.method_22336().method_15562(class_1944.field_9284);
        this.blockLightArrays[sectionIdx] = blockLightProvider.method_15544(pos);
        this.skyLightArrays[sectionIdx] = skyLightProvider.method_15544(pos);
    }

    private void populateBlockArrays(int sectionIdx, class_4076 pos, class_2791 chunk) {
        class_2826 section = WorldSlice.getChunkSection(chunk, pos);
        if (section == null || section.method_12261()) {
            section = EMPTY_SECTION;
        }
        class_2841 container = section.method_12265();
        class_3508 intArray = container.field_12941;
        class_2837 palette = container.field_12936;
        class_2680[] dst = this.blockStatesArrays[sectionIdx];
        int minBlockX = Math.max(this.minX, pos.method_19527());
        int maxBlockX = Math.min(this.maxX, pos.method_19530());
        int minBlockY = Math.max(this.minY, pos.method_19528());
        int maxBlockY = Math.min(this.maxY, pos.method_19531());
        int minBlockZ = Math.max(this.minZ, pos.method_19529());
        int maxBlockZ = Math.min(this.maxZ, pos.method_19532());
        int prevPaletteId = -1;
        class_2680 prevPaletteState = null;
        for (int y = minBlockY; y <= maxBlockY; ++y) {
            for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                for (int x = minBlockX; x <= maxBlockX; ++x) {
                    class_2680 state;
                    int blockIdx = WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                    int paletteId = intArray.method_15211(blockIdx);
                    if (prevPaletteId == paletteId) {
                        state = prevPaletteState;
                    } else {
                        state = (class_2680)palette.method_12288(paletteId);
                        if (state == null) {
                            state = (class_2680)container.field_12935;
                        }
                        prevPaletteState = state;
                        prevPaletteId = paletteId;
                    }
                    dst[blockIdx] = state;
                }
            }
        }
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.getBlockState(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2680 getBlockState(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public class_2680 getOriginBlockState(int x, int y, int z) {
        return this.originBlockStates[WorldSlice.getLocalBlockIndex(x, y, z)];
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public class_3610 getFluidState(int x, int y, int z) {
        return this.getBlockState(x, y, z).method_26227();
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return this.world.method_24852(direction, shaded);
    }

    public class_3568 method_22336() {
        return this.world.method_22336();
    }

    public class_2586 method_8321(class_2338 pos) {
        return this.getBlockEntity(pos, class_2818.class_2819.field_12860);
    }

    public class_2586 getBlockEntity(class_2338 pos, class_2818.class_2819 type) {
        int relX = pos.method_10263() - this.baseX;
        int relZ = pos.method_10260() - this.baseZ;
        return this.chunks[WorldSlice.getLocalChunkIndex(relX >> 4, relZ >> 4)].method_12201(pos, type);
    }

    public int method_23752(class_2338 pos, ColorResolver resolver) {
        BiomeColorCache cache;
        if (this.prevColorResolver == resolver) {
            cache = this.prevColorCache;
        } else {
            cache = this.colorResolvers.get(resolver);
            if (cache == null) {
                cache = new BiomeColorCache(resolver, this);
                this.colorResolvers.put(resolver, cache);
            }
            this.prevColorResolver = resolver;
            this.prevColorCache = cache;
        }
        return cache.getBlendedColor(pos);
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        switch (type) {
            case field_9284: {
                return this.getLightLevel(this.skyLightArrays, pos);
            }
            case field_9282: {
                return this.getLightLevel(this.blockLightArrays, pos);
            }
        }
        return 0;
    }

    public int method_22335(class_2338 pos, int ambientDarkness) {
        return 0;
    }

    public boolean method_8311(class_2338 pos) {
        return false;
    }

    private int getLightLevel(class_2804[] arrays, class_2338 pos) {
        int relZ;
        int relY;
        int relX = pos.method_10263() - this.baseX;
        class_2804 array = arrays[WorldSlice.getLocalSectionIndex(relX >> 4, (relY = pos.method_10264() - this.baseY) >> 4, (relZ = pos.method_10260() - this.baseZ) >> 4)];
        if (array != null) {
            return array.method_12139(relX & 0xF, relY & 0xF, relZ & 0xF);
        }
        return 0;
    }

    public class_1959 method_16359(int x, int y, int z) {
        int x2 = (x >> 2) - (this.baseX >> 4);
        int z2 = (z >> 2) - (this.baseZ >> 4);
        class_4548 array = this.biomeArrays[WorldSlice.getLocalChunkIndex(x2, z2)];
        if (array != null) {
            return array.method_16359(x, y, z);
        }
        return this.world.method_22387(x, y, z);
    }

    public class_1959 getCachedBiome(int x, int z) {
        int relX = x - this.baseX;
        int relZ = z - this.baseZ;
        return this.biomeCaches[WorldSlice.getLocalChunkIndex(relX >> 4, relZ >> 4)].getBiome(this, x, z);
    }

    public class_4076 getOrigin() {
        return this.origin;
    }

    @Override
    public void reset() {
        for (BiomeCache cache : this.biomeCaches) {
            if (cache == null) continue;
            this.biomeCacheManager.release(cache);
        }
        Arrays.fill(this.biomeCaches, null);
        Arrays.fill(this.biomeArrays, null);
        Arrays.fill(this.blockLightArrays, null);
        Arrays.fill(this.skyLightArrays, null);
        this.biomeCacheManager = null;
        this.chunks = null;
        this.world = null;
        this.colorResolvers.clear();
        this.prevColorCache = null;
        this.prevColorResolver = null;
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y << TABLE_BITS << TABLE_BITS | z << TABLE_BITS | x;
    }

    public static int getLocalChunkIndex(int x, int z) {
        return z << TABLE_BITS | x;
    }

    private static class_2826 getChunkSection(class_2791 chunk, class_4076 pos) {
        class_2826 section = null;
        if (!class_1937.method_8476((int)class_4076.method_18688((int)pos.method_10264()))) {
            section = chunk.method_12006()[pos.method_10264()];
        }
        return section;
    }
}

