/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import java.nio.FloatBuffer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

public abstract class ChunkProgram
extends GlProgram {
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale;
    private final int uTextureScale;
    private final int uBlockTex = this.getUniformLocation("u_BlockTex");
    private final int uLightTex = this.getUniformLocation("u_LightTex");
    private final ChunkShaderFogComponent fogShader;

    protected ChunkProgram(class_2960 name, int handle, Function<ChunkProgram, ChunkShaderFogComponent> fogShaderFunction) {
        super(name, handle);
        this.uModelScale = this.getUniformLocation("u_ModelScale");
        this.uTextureScale = this.getUniformLocation("u_TextureScale");
        this.fogShader = fogShaderFunction.apply(this);
    }

    public void setup(class_4587 matrixStack, float modelScale, float textureScale) {
        GL20.glUniform1i((int)this.uBlockTex, (int)0);
        GL20.glUniform1i((int)this.uLightTex, (int)2);
        GL20.glUniform3f((int)this.uModelScale, (float)modelScale, (float)modelScale, (float)modelScale);
        GL20.glUniform2f((int)this.uTextureScale, (float)textureScale, (float)textureScale);
        this.fogShader.setup();
        class_4587.class_4665 matrices = matrixStack.method_23760();
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer bufProjection = stack.mallocFloat(16);
            FloatBuffer bufModelView = stack.mallocFloat(16);
            FloatBuffer bufModelViewProjection = stack.mallocFloat(16);
            GL15.glGetFloatv((int)2983, (FloatBuffer)bufProjection);
            matrices.method_23761().method_4932(bufModelView);
            GL11.glPushMatrix();
            GL11.glLoadMatrixf((FloatBuffer)bufProjection);
            GL11.glMultMatrixf((FloatBuffer)bufModelView);
            GL15.glGetFloatv((int)2982, (FloatBuffer)bufModelViewProjection);
            GL11.glPopMatrix();
            GL20.glUniformMatrix4fv((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)bufModelViewProjection);
        }
    }
}

