/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.SortedSet;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderManager;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl20.GL20ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl30.GL30ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl43.GL43ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.DefaultModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.pipeline.context.GlobalRenderContext;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import me.jellysquid.mods.sodium.common.util.ListUtil;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_4720;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_824;

public class SodiumWorldRenderer
implements ChunkStatusListener {
    private static SodiumWorldRenderer instance;
    private final class_310 client;
    private class_638 world;
    private int renderDistance;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private boolean useEntityCulling;
    private final LongSet loadedChunkPositions = new LongOpenHashSet();
    private final Set<class_2586> globalBlockEntities = new ObjectOpenHashSet();
    private class_4604 frustum;
    private ChunkRenderManager<?> chunkRenderManager;
    private BlockRenderPassManager renderPassManager;
    private ChunkRenderBackend<?> chunkRenderBackend;

    public static SodiumWorldRenderer create() {
        if (instance == null) {
            instance = new SodiumWorldRenderer(class_310.method_1551());
        }
        return instance;
    }

    public static SodiumWorldRenderer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Renderer not initialized");
        }
        return instance;
    }

    private SodiumWorldRenderer(class_310 client) {
        this.client = client;
    }

    public void setWorld(class_638 world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    private void loadWorld(class_638 world) {
        this.world = world;
        GlobalRenderContext.createRenderContext((class_1920)this.world);
        this.initRenderer();
        ((ChunkStatusListenerManager)world.method_2935()).setListener(this);
    }

    private void unloadWorld() {
        GlobalRenderContext.destroyRenderContext((class_1920)this.world);
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.loadedChunkPositions.clear();
        this.globalBlockEntities.clear();
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.markDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.chunkRenderManager.isBuildComplete();
    }

    public void updateChunks(class_4184 camera, class_4604 frustum, boolean hasForcedFrustum, int frame, boolean spectator) {
        boolean dirty;
        this.frustum = frustum;
        this.useEntityCulling = SodiumClientMod.options().advanced.useAdvancedEntityCulling;
        if (this.client.field_1690.field_1870 != this.renderDistance) {
            this.reload();
        }
        class_3695 profiler = this.client.method_16011();
        profiler.method_15396("camera_setup");
        class_746 player = this.client.field_1724;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        class_243 cameraPos = camera.method_19326();
        this.chunkRenderManager.setCameraPosition(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
        float pitch = camera.method_19329();
        float yaw = camera.method_19330();
        boolean bl = dirty = cameraPos.field_1352 != this.lastCameraX || cameraPos.field_1351 != this.lastCameraY || cameraPos.field_1350 != this.lastCameraZ || (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw;
        if (dirty) {
            this.chunkRenderManager.markDirty();
        }
        this.lastCameraX = cameraPos.field_1352;
        this.lastCameraY = cameraPos.field_1351;
        this.lastCameraZ = cameraPos.field_1350;
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        profiler.method_15405("chunk_update");
        this.chunkRenderManager.updateChunks();
        if (!hasForcedFrustum && this.chunkRenderManager.isDirty()) {
            profiler.method_15405("chunk_graph_rebuild");
            this.chunkRenderManager.update(camera, (FrustumExtended)frustum, frame, spectator);
        }
        profiler.method_15405("visible_chunk_tick");
        this.chunkRenderManager.tickVisibleRenders();
        profiler.method_15407();
        class_1297.method_5840((double)(class_3532.method_15350((double)((double)this.client.field_1690.field_1870 / 8.0), (double)1.0, (double)2.5) * (double)this.client.field_1690.field_24214));
    }

    public void drawChunkLayer(class_1921 renderLayer, class_4587 matrixStack, double x, double y, double z) {
        BlockRenderPass pass = this.renderPassManager.getRenderPassForLayer(renderLayer);
        pass.startDrawing();
        this.chunkRenderManager.renderLayer(matrixStack, pass, x, y, z);
        pass.endDrawing();
        RenderSystem.clearCurrentColor();
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        this.initRenderer();
    }

    private void initRenderer() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.renderDistance = this.client.field_1690.field_1870;
        SodiumGameOptions opts = SodiumClientMod.options();
        this.renderPassManager = BlockRenderPassManager.createDefaultMappings();
        ChunkVertexType vertexFormat = opts.advanced.useCompactVertexFormat ? DefaultModelVertexFormats.MODEL_VERTEX_HFP : DefaultModelVertexFormats.MODEL_VERTEX_SFP;
        this.chunkRenderBackend = SodiumWorldRenderer.createChunkRenderBackend(opts.advanced.chunkRendererBackend, vertexFormat);
        this.chunkRenderBackend.createShaders();
        this.chunkRenderManager = new ChunkRenderManager(this, this.chunkRenderBackend, this.renderPassManager, this.world, this.renderDistance);
        this.chunkRenderManager.restoreChunks((LongCollection)this.loadedChunkPositions);
    }

    private static ChunkRenderBackend<?> createChunkRenderBackend(SodiumGameOptions.ChunkRendererBackendOption opt, ChunkVertexType vertexFormat) {
        boolean disableBlacklist = SodiumClientMod.options().advanced.disableDriverBlacklist;
        switch (opt) {
            case GL43: {
                if (GL43ChunkRenderBackend.isSupported(disableBlacklist)) {
                    return new GL43ChunkRenderBackend(vertexFormat);
                }
            }
            case GL30: {
                if (GL30ChunkRenderBackend.isSupported(disableBlacklist)) {
                    return new GL30ChunkRenderBackend(vertexFormat);
                }
            }
            case GL20: {
                if (!GL20ChunkRenderBackend.isSupported(disableBlacklist)) break;
                return new GL20ChunkRenderBackend(vertexFormat);
            }
        }
        throw new IllegalArgumentException("No suitable chunk render backends exist");
    }

    public void renderTileEntities(class_4587 matrices, class_4599 bufferBuilders, Long2ObjectMap<SortedSet<class_3191>> blockBreakingProgressions, class_4184 camera, float tickDelta) {
        class_2338 pos;
        class_4597.class_4598 immediate = bufferBuilders.method_23000();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.method_10216();
        double y = cameraPos.method_10214();
        double z = cameraPos.method_10215();
        for (class_2586 blockEntity : this.chunkRenderManager.getVisibleBlockEntities()) {
            int stage;
            pos = blockEntity.method_11016();
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - x, (double)pos.method_10264() - y, (double)pos.method_10260() - z);
            class_4597.class_4598 consumer = immediate;
            SortedSet breakingInfos = (SortedSet)blockBreakingProgressions.get(pos.method_10063());
            if (breakingInfos != null && !breakingInfos.isEmpty() && (stage = ((class_3191)breakingInfos.last()).method_13988()) >= 0) {
                class_4587.class_4665 entry = matrices.method_23760();
                class_4583 transformer = new class_4583(bufferBuilders.method_23001().getBuffer((class_1921)class_1088.field_21772.get(stage)), entry.method_23761(), entry.method_23762());
                consumer = arg_0 -> SodiumWorldRenderer.lambda$renderTileEntities$0((class_4588)transformer, immediate, arg_0);
            }
            class_824.field_4346.method_3555(blockEntity, tickDelta, matrices, (class_4597)consumer);
            matrices.method_22909();
        }
        for (class_2586 blockEntity : this.globalBlockEntities) {
            pos = blockEntity.method_11016();
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - x, (double)pos.method_10264() - y, (double)pos.method_10260() - z);
            class_824.field_4346.method_3555(blockEntity, tickDelta, matrices, (class_4597)immediate);
            matrices.method_22909();
        }
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.loadedChunkPositions.add(class_1923.method_8331((int)x, (int)z));
        this.chunkRenderManager.onChunkAdded(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.loadedChunkPositions.remove(class_1923.method_8331((int)x, (int)z));
        this.chunkRenderManager.onChunkRemoved(x, z);
    }

    public void onChunkRenderUpdated(int x, int y, int z, ChunkRenderData meshBefore, ChunkRenderData meshAfter) {
        ListUtil.updateList(this.globalBlockEntities, meshBefore.getGlobalBlockEntities(), meshAfter.getGlobalBlockEntities());
        this.chunkRenderManager.onChunkRenderUpdates(x, y, z, meshAfter);
    }

    public boolean isEntityVisible(class_1297 entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        class_238 box = entity.method_5830();
        if (box.field_1325 < 0.5 || box.field_1322 > 255.5) {
            return true;
        }
        int minX = class_3532.method_15357((double)(box.field_1323 - 0.5)) >> 4;
        int minY = class_3532.method_15357((double)(box.field_1322 - 0.5)) >> 4;
        int minZ = class_3532.method_15357((double)(box.field_1321 - 0.5)) >> 4;
        int maxX = class_3532.method_15357((double)(box.field_1320 + 0.5)) >> 4;
        int maxY = class_3532.method_15357((double)(box.field_1325 + 0.5)) >> 4;
        int maxZ = class_3532.method_15357((double)(box.field_1324 + 0.5)) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.chunkRenderManager.isChunkVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public class_4604 getFrustum() {
        return this.frustum;
    }

    public String getChunksDebugString() {
        return String.format("C: %s/%s", this.chunkRenderManager.getVisibleChunkCount(), this.chunkRenderManager.getTotalSections());
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.chunkRenderManager.scheduleRebuild(x, y, z, important);
    }

    public ChunkRenderBackend<?> getChunkRenderer() {
        return this.chunkRenderBackend;
    }

    private static /* synthetic */ class_4588 lambda$renderTileEntities$0(class_4588 transformer, class_4597.class_4598 immediate, class_1921 layer) {
        return layer.method_23037() ? class_4720.method_24037((class_4588)transformer, (class_4588)immediate.getBuffer(layer)) : immediate.getBuffer(layer);
    }
}

