/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderWorkarounds;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final class_2960 name;

    public GlShader(ShaderType type, class_2960 name, String src, ShaderConstants constants) {
        int result;
        this.name = name;
        src = GlShader.processShader(src, constants);
        int handle = GL20.glCreateShader((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, src);
        GL20.glCompileShader((int)handle);
        String log = GL20.glGetShaderInfoLog((int)handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + this.name + ": " + log);
        }
        if ((result = GL20.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
    }

    private static String processShader(String src, ShaderConstants constants) {
        StringBuilder builder = new StringBuilder(src.length());
        boolean patched = false;
        try (BufferedReader reader = new BufferedReader(new StringReader(src));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
                if (patched || !line.startsWith("#version")) continue;
                for (String macro : constants.getDefineStrings()) {
                    builder.append(macro).append('\n');
                }
                patched = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not process shader source", e);
        }
        return builder.toString();
    }

    public class_2960 getName() {
        return this.name;
    }

    public void delete() {
        GL20.glDeleteShader((int)this.handle());
        this.invalidateHandle();
    }
}

