/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SimplePool<T> {
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private final Supplier<T> supplier;
    private final Consumer<T> resetter;

    public SimplePool(Supplier<T> supplier, Consumer<T> resetter) {
        this.supplier = supplier;
        this.resetter = resetter;
    }

    public SimplePool(Supplier<T> supplier) {
        this(supplier, t -> {});
    }

    public T get() {
        T obj = this.queue.poll();
        if (obj == null) {
            return this.supplier.get();
        }
        this.resetter.accept(obj);
        return obj;
    }

    public void readd(T t) {
        this.queue.add(t);
    }
}

