/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.tile.provider;

import io.github.nuclearfarts.cbt.tile.Tile;
import io.github.nuclearfarts.cbt.tile.loader.TileLoader;
import io.github.nuclearfarts.cbt.tile.provider.BasicTileProvider;
import io.github.nuclearfarts.cbt.util.CBTUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4730;

public interface TileProvider {
    public List<class_4730> getIdsToLoad();

    public class_1058[] load(Function<class_4730, class_1058> var1);

    public static TileProvider load(Properties properties, class_2960 location, class_3300 manager) throws IOException {
        return ((Factory)PrivateConstants.TILE_PROVIDERS.get((Object)properties.getProperty("method"))).create(TileLoader.load(properties, location, manager).getTiles());
    }

    public static TileProvider load(class_2960 propertiesLocation, class_3300 manager) throws IOException {
        Properties properties = new Properties();
        properties.load(manager.method_14486(propertiesLocation).method_14482());
        return TileProvider.load(properties, CBTUtil.directoryOf(propertiesLocation), manager);
    }

    public static void registerTileProviderFactory(String method, Factory<?> loader) {
        PrivateConstants.TILE_PROVIDERS.put((Object)method, loader);
    }

    public static final class PrivateConstants {
        private static final Object2ObjectMap<String, Factory<?>> TILE_PROVIDERS = new Object2ObjectOpenHashMap();

        private PrivateConstants() {
        }

        static {
            TILE_PROVIDERS.defaultReturnValue(BasicTileProvider::new);
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends TileProvider> {
        public T create(Tile[] var1) throws IOException;
    }
}

