/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.tile.provider;

import io.github.nuclearfarts.cbt.ConnectedBlockTextures;
import io.github.nuclearfarts.cbt.tile.Tile;
import io.github.nuclearfarts.cbt.tile.provider.TileProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_4730;

public class CompactTileProvider
implements TileProvider {
    private final List<class_4730> spriteIds = new ArrayList<class_4730>();

    public CompactTileProvider(Tile[] origTiles) throws IOException {
        int i;
        class_1011[] origImages = new class_1011[5];
        for (i = 0; i < 5; ++i) {
            origImages[i] = origTiles[i].getImage();
        }
        for (i = 0; i <= 46; ++i) {
            class_1011 tile = new class_1011(origImages[0].method_4307(), origImages[0].method_4323(), true);
            short bithack = ConnectedBlockTextures.CTM_TO_IDEALIZED_BITHACK[i];
            if ((bithack & 0x50) == 0) {
                CompactTileProvider.blitQuarter(0, 0, origImages[0], tile);
            } else if ((bithack & 0x10) == 0) {
                CompactTileProvider.blitQuarter(0, 0, origImages[2], tile);
            } else if ((bithack & 0x40) == 0) {
                CompactTileProvider.blitQuarter(0, 0, origImages[3], tile);
            } else if ((bithack & 0x80) == 0) {
                CompactTileProvider.blitQuarter(0, 0, origImages[4], tile);
            } else {
                CompactTileProvider.blitQuarter(0, 0, origImages[1], tile);
            }
            if ((bithack & 0x48) == 0) {
                CompactTileProvider.blitQuarter(1, 0, origImages[0], tile);
            } else if ((bithack & 8) == 0) {
                CompactTileProvider.blitQuarter(1, 0, origImages[2], tile);
            } else if ((bithack & 0x40) == 0) {
                CompactTileProvider.blitQuarter(1, 0, origImages[3], tile);
            } else if ((bithack & 0x20) == 0) {
                CompactTileProvider.blitQuarter(1, 0, origImages[4], tile);
            } else {
                CompactTileProvider.blitQuarter(1, 0, origImages[1], tile);
            }
            if ((bithack & 0x12) == 0) {
                CompactTileProvider.blitQuarter(0, 1, origImages[0], tile);
            } else if ((bithack & 0x10) == 0) {
                CompactTileProvider.blitQuarter(0, 1, origImages[2], tile);
            } else if ((bithack & 2) == 0) {
                CompactTileProvider.blitQuarter(0, 1, origImages[3], tile);
            } else if ((bithack & 4) == 0) {
                CompactTileProvider.blitQuarter(0, 1, origImages[4], tile);
            } else {
                CompactTileProvider.blitQuarter(0, 1, origImages[1], tile);
            }
            if ((bithack & 0xA) == 0) {
                CompactTileProvider.blitQuarter(1, 1, origImages[0], tile);
            } else if ((bithack & 8) == 0) {
                CompactTileProvider.blitQuarter(1, 1, origImages[2], tile);
            } else if ((bithack & 2) == 0) {
                CompactTileProvider.blitQuarter(1, 1, origImages[3], tile);
            } else if ((bithack & 1) == 0) {
                CompactTileProvider.blitQuarter(1, 1, origImages[4], tile);
            } else {
                CompactTileProvider.blitQuarter(1, 1, origImages[1], tile);
            }
            this.spriteIds.add(new class_4730(class_1059.field_5275, ConnectedBlockTextures.resourcePack.dynamicallyPutImage(tile)));
        }
    }

    private static void blitQuarter(int offsetX, int offsetY, class_1011 src, class_1011 dst) {
        int w = src.method_4307() / 2;
        int h = src.method_4323() / 2;
        int x = w * offsetX;
        int y = h * offsetY;
        for (int i = x; i < w + x; ++i) {
            for (int j = y; j < h + y; ++j) {
                dst.method_4305(i, j, src.method_4315(i, j));
            }
        }
    }

    @Override
    public List<class_4730> getIdsToLoad() {
        return this.spriteIds;
    }

    @Override
    public class_1058[] load(Function<class_4730, class_1058> textureGetter) {
        class_1058[] sprites = new class_1058[this.spriteIds.size()];
        for (int i = 0; i < sprites.length; ++i) {
            sprites[i] = textureGetter.apply(this.spriteIds.get(i));
        }
        return sprites;
    }
}

