/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.tile.loader;

import io.github.nuclearfarts.cbt.tile.ResourceBackedTile;
import io.github.nuclearfarts.cbt.tile.Tile;
import io.github.nuclearfarts.cbt.tile.loader.TileLoader;
import io.github.nuclearfarts.cbt.util.CBTUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class BasicTileLoader
implements TileLoader {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^\\d+-\\d+$");
    private final Tile[] tiles;

    public BasicTileLoader(Properties properties, class_2960 location, class_3300 manager) {
        this(properties.getProperty("tiles").split(" "), location, manager);
    }

    public BasicTileLoader(String[] tileDefs, class_2960 location, class_3300 manager) {
        ArrayList<ResourceBackedTile> loadedTiles = new ArrayList<ResourceBackedTile>();
        for (String tileDef : tileDefs) {
            if (RANGE_PATTERN.matcher(tileDef).find()) {
                String[] defSplit = tileDef.split("-");
                int min = Integer.parseInt(defSplit[0]);
                int max = Integer.parseInt(defSplit[1]);
                for (int i = min; i <= max; ++i) {
                    loadedTiles.add(new ResourceBackedTile(CBTUtil.appendId(location, "/" + i + ".png"), manager));
                }
                continue;
            }
            if (tileDef.contains("/")) {
                if (tileDef.startsWith("~")) {
                    tileDef = "optifine" + tileDef.substring(1);
                }
                loadedTiles.add(new ResourceBackedTile(new class_2960(CBTUtil.ensurePngExtension(tileDef)), manager));
                continue;
            }
            loadedTiles.add(new ResourceBackedTile(CBTUtil.appendId(location, "/" + CBTUtil.ensurePngExtension(tileDef)), manager));
        }
        this.tiles = loadedTiles.toArray(new Tile[loadedTiles.size()]);
    }

    @Override
    public Tile[] getTiles() {
        return this.tiles;
    }
}

