/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.sprite;

import io.github.nuclearfarts.cbt.config.CTMConfig;
import io.github.nuclearfarts.cbt.sprite.SpriteProvider;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public abstract class BaseSpriteProvider
implements SpriteProvider {
    protected final class_1058[] connects;
    protected final Predicate<class_1058> tileMatcher;
    protected final Predicate<class_2350> faceMatcher;
    protected final BiPredicate<class_1920, class_2338> worldConditions;

    public BaseSpriteProvider(class_1058[] connects, CTMConfig config) {
        this.connects = connects;
        Predicate<class_2960> tileMatcher = config.getTileMatcher();
        this.tileMatcher = tileMatcher == null ? null : s -> tileMatcher.test(s.method_4598());
        this.faceMatcher = config.getFaceMatcher();
        this.worldConditions = config.getWorldConditions();
    }

    @Override
    public boolean affectsBlock(class_1920 view, class_2680 state, class_2338 pos) {
        return this.worldConditions.test(view, pos);
    }

    @Override
    public boolean affectsDirection(class_2350 side) {
        return this.faceMatcher.test(side);
    }

    @Override
    public boolean affectsSprite(QuadView quad, SpriteFinder finder) {
        return this.tileMatcher == null ? true : this.tileMatcher.test(finder.find(quad, 0));
    }

    protected class_2680[][] getAll(class_1920 view, class_2350 upD, class_2350 leftD, class_2338 pos) {
        class_2680[][] result = new class_2680[3][3];
        class_2338 left = pos.method_10093(leftD);
        class_2338 right = pos.method_10093(leftD.method_10153());
        result[0][0] = view.method_8320(left.method_10093(upD));
        result[0][1] = view.method_8320(left);
        result[0][2] = view.method_8320(left.method_10093(upD.method_10153()));
        result[1][0] = view.method_8320(pos.method_10093(upD));
        result[1][1] = null;
        result[1][2] = view.method_8320(pos.method_10093(upD.method_10153()));
        result[2][0] = view.method_8320(right.method_10093(upD));
        result[2][1] = view.method_8320(right);
        result[2][2] = view.method_8320(right.method_10093(upD.method_10153()));
        return result;
    }
}

