/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.resource;

import com.google.common.collect.ImmutableSet;
import io.github.nuclearfarts.cbt.mixin.NativeImageAccessor;
import io.github.nuclearfarts.cbt.tile.Tile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3300;

public class CBTResourcePack
implements class_3262 {
    private static final Set<String> NAMESPACES = ImmutableSet.of((Object)"connectedblocktextures");
    private final Map<String, class_2960> aliases = new HashMap<String, class_2960>();
    private final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private final class_3300 manager;
    private int genCounter = 0;

    public CBTResourcePack(class_3300 manager) {
        this.manager = manager;
    }

    public void putResource(String resource, byte[] data) {
        this.resources.put(resource, data);
    }

    public void alias(String location, class_2960 to) {
        this.aliases.put(location, to);
    }

    public void putImage(String location, class_1011 image) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ((NativeImageAccessor)image).invokeWrite(Channels.newChannel(byteOut));
        image.close();
        this.putResource(location, byteOut.toByteArray());
    }

    public class_2960 dynamicallyPutImage(class_1011 image) {
        String texPath = "gen/" + this.genCounter++;
        this.putImage("assets/connectedblocktextures/textures/" + texPath + ".png", image);
        return new class_2960("connectedblocktextures", texPath);
    }

    public class_2960 dynamicallyPutTile(Tile tile) {
        String texPath = "gen/" + this.genCounter++;
        this.putTile("assets/connectedblocktextures/textures/" + texPath + ".png", tile);
        return new class_2960("connectedblocktextures", texPath);
    }

    public void putTile(String location, Tile tile) {
        if (tile.hasResource()) {
            this.alias(location, tile.getResource());
        } else {
            try {
                this.putImage(location, tile.getImage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
    }

    public InputStream method_14410(String fileName) throws IOException {
        byte[] data = this.resources.get(fileName);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        class_2960 aliasOf = this.aliases.get(fileName);
        if (aliasOf != null) {
            return this.manager.method_14486(aliasOf).method_14482();
        }
        throw new IOException("generated resources pack has no data or alias for " + fileName);
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        if (type == class_3264.field_14190) {
            throw new IOException("reading server data from connectedblocktextures client resource pack");
        }
        return this.method_14410(type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832());
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        if (type == class_3264.field_14190) {
            return Collections.emptyList();
        }
        String start = "assets/" + namespace + "/" + prefix;
        return this.resources.keySet().stream().filter(s -> s.startsWith(start) && pathFilter.test((String)s)).map(CBTResourcePack::fromPath).collect(Collectors.toList());
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        String path = type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832();
        return this.resources.containsKey(path) || this.aliases.containsKey(path);
    }

    public Set<String> method_14406(class_3264 type) {
        return NAMESPACES;
    }

    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        return null;
    }

    public String method_14409() {
        return "Connected Block Textures generated resources";
    }

    private static class_2960 fromPath(String path) {
        String[] split = path.split("/", 2);
        return new class_2960(split[0], split[1]);
    }
}

