/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.mixin;

import io.github.nuclearfarts.cbt.ConnectedBlockTextures;
import io.github.nuclearfarts.cbt.config.CTMConfig;
import io.github.nuclearfarts.cbt.model.CBTUnbakedModel;
import io.github.nuclearfarts.cbt.util.CBTUtil;
import io.github.nuclearfarts.cbt.util.VoidSet;
import io.github.nuclearfarts.cbt.util.function.MutableCachingSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4730;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1088.class})
public abstract class ModelLoaderMixin {
    @Shadow
    @Final
    private Map<class_2960, class_1100> field_5376;
    @Shadow
    @Final
    private Map<class_2960, class_1100> field_5394;
    @Shadow
    @Final
    private class_3300 field_5379;

    @Redirect(method={"<init>"}, at=@At(value="INVOKE_STRING", target="net/minecraft/util/profiler/Profiler.swap(Ljava/lang/String;)V", args={"ldc=textures"}))
    private void injectCbtModels(class_3695 on, String str) {
        on.method_15405("ctm");
        ConnectedBlockTextures.overrideIdentifierCharRestriction = true;
        ConnectedBlockTextures.identifierOverrideThread = Thread.currentThread();
        ArrayList<CTMConfig> data = new ArrayList<CTMConfig>();
        Collection propertiesIds = this.field_5379.method_14488("optifine/ctm", s -> s.endsWith(".properties"));
        for (class_2960 id2 : propertiesIds) {
            try {
                data.add(CTMConfig.load(id2, this.field_5379));
            }
            catch (Exception e) {
                ConnectedBlockTextures.LOGGER.error("Error loading connected textures config at " + id2, (Throwable)e);
            }
        }
        HashSet priorityFails = new HashSet();
        MutableCachingSupplier textureCached = new MutableCachingSupplier();
        this.field_5376.forEach((id, model) -> {
            class_1100 newModel;
            class_1091 modelId;
            if (id instanceof class_1091 && !(modelId = (class_1091)id).method_4740().equals("inventory") && (newModel = this.checkCtmConfigs(modelId, (class_1100)model, textureCached, (List<CTMConfig>)data, priorityFails)) != model) {
                this.field_5376.put((class_2960)id, newModel);
                this.field_5394.put((class_2960)id, newModel);
            }
        });
        ConnectedBlockTextures.overrideIdentifierCharRestriction = false;
        on.method_15405(str);
    }

    @Unique
    private class_1100 checkCtmConfigs(class_1091 id, class_1100 model, MutableCachingSupplier<Collection<class_4730>> textureCached, List<CTMConfig> data, Set<class_2960> priorityFails) {
        TreeSet<CTMConfig> configs = new TreeSet<CTMConfig>();
        boolean foundNewConfigs = false;
        do {
            TreeSet<CTMConfig> newConfigs = new TreeSet<CTMConfig>();
            class_1100 javaPls = model;
            textureCached.set(() -> javaPls.method_4754(arg_0 -> ((class_1088)((class_1088)this)).method_4726(arg_0), VoidSet.get()));
            for (CTMConfig c : data) {
                if (!c.affectsModel(id, textureCached) || !CBTUtil.allMatchThrowable(textureCached.get(), s -> this.checkPack((class_4730)s, c.getResourcePackPriority(), priorityFails)) || !configs.add(c)) continue;
                newConfigs.add(c);
            }
            boolean bl = foundNewConfigs = !newConfigs.isEmpty();
            if (!foundNewConfigs) continue;
            model = new CBTUnbakedModel(model, newConfigs.toArray(new CTMConfig[newConfigs.size()]));
        } while (foundNewConfigs);
        return model;
    }

    @Unique
    private boolean checkPack(class_4730 spriteId, int ctmPackPriority, Set<class_2960> fails) {
        String spritePack;
        class_2960 texId = spriteId.method_24147();
        try {
            spritePack = this.field_5379.method_14486(new class_2960(texId.method_12836(), "textures/" + texId.method_12832() + ".png")).method_14480();
        }
        catch (IOException e) {
            if (fails.add(texId)) {
                ConnectedBlockTextures.LOGGER.error("Error checking resource pack priority", (Throwable)e);
            }
            return true;
        }
        return ConnectedBlockTextures.RESOURCE_PACK_PRIORITY_MAP.getInt((Object)spritePack) <= ctmPackPriority;
    }
}

