/*
 * Decompiled with CFR 0.152.
 */
package io.github.nuclearfarts.cbt.config;

import com.google.common.base.Predicates;
import io.github.nuclearfarts.cbt.ConnectedBlockTextures;
import io.github.nuclearfarts.cbt.config.CTMConfig;
import io.github.nuclearfarts.cbt.sprite.SpriteProvider;
import io.github.nuclearfarts.cbt.tile.provider.TileProvider;
import io.github.nuclearfarts.cbt.util.CBTUtil;
import io.github.nuclearfarts.cbt.util.CursedBiomeThing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1091;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4730;

public abstract class BaseCTMConfig<Self extends BaseCTMConfig<Self>>
implements CTMConfig {
    protected final TileProvider tileProvider;
    protected final Predicate<class_2960> tileMatcher;
    protected final Predicate<class_2960> blockMatcher;
    protected final Predicate<class_2350> faceMatcher;
    protected final BiPredicate<class_1920, class_2338> worldConditions;
    protected final int packPriority;
    protected final int weight;
    protected final String fileName;
    protected final SpriteProviderFactory<Self> spriteProviderFactory;

    public BaseCTMConfig(Properties properties, class_2960 location, class_3300 manager, SpriteProviderFactory<Self> bakedModelFactory, String packName) throws IOException {
        String packOverride;
        IntPredicate heightMatcher;
        Predicate<class_1959> biomeMatcher;
        this.tileMatcher = properties.containsKey("matchTiles") ? Arrays.stream(properties.getProperty("matchTiles").split(" ")).map(s -> CBTUtil.prependId(new class_2960(s), "block/")).collect(Collectors.toCollection(HashSet::new))::contains : null;
        this.blockMatcher = properties.containsKey("matchBlocks") ? Arrays.stream(properties.getProperty("matchBlocks").split(" ")).map(class_2960::new).collect(Collectors.toCollection(HashSet::new))::contains : Predicates.alwaysTrue();
        if (properties.containsKey("biomes")) {
            class_2385 biomes = class_310.method_1551().field_1687.method_30349().method_30530(class_2378.field_25114);
            biomeMatcher = Arrays.stream(properties.getProperty("biomes").split(" ")).map(class_2960::new).map(arg_0 -> ((class_2378)biomes).method_10223(arg_0)).collect(Collectors.toCollection(HashSet::new))::contains;
        } else {
            biomeMatcher = null;
        }
        if (properties.containsKey("heights")) {
            ArrayList<IntPredicate> heightTests = new ArrayList<IntPredicate>();
            for (String range : properties.getProperty("heights").split(" ")) {
                String[] split = range.split("-");
                int min = Integer.parseInt(split[0]);
                int max = Integer.parseInt(split[1]);
                heightTests.add(i -> min <= i && i <= max);
            }
            heightMatcher = heightTests.size() == 1 ? (IntPredicate)heightTests.get(0) : i -> CBTUtil.satisfiesAny(heightTests, i);
        } else {
            heightMatcher = i -> true;
        }
        this.worldConditions = biomeMatcher != null ? (w, p) -> biomeMatcher.test(CursedBiomeThing.getBiome(w, p)) && heightMatcher.test(p.method_10264()) : (w, p) -> heightMatcher.test(p.method_10264());
        if (properties.containsKey("faces")) {
            EnumSet<class_2350> faces = EnumSet.noneOf(class_2350.class);
            String[] stringArray = properties.getProperty("faces").split(" ");
            int n = stringArray.length;
            block13: for (int j = 0; j < n; ++j) {
                String face;
                switch (face = stringArray[j]) {
                    case "sides": {
                        faces.add(class_2350.field_11043);
                        faces.add(class_2350.field_11034);
                        faces.add(class_2350.field_11039);
                        faces.add(class_2350.field_11035);
                        continue block13;
                    }
                    case "top": {
                        faces.add(class_2350.field_11036);
                        continue block13;
                    }
                    case "bottom": {
                        faces.add(class_2350.field_11033);
                        continue block13;
                    }
                    case "all": {
                        for (class_2350 d : class_2350.values()) {
                            faces.add(d);
                        }
                        continue block13;
                    }
                    default: {
                        faces.add(class_2350.valueOf((String)face.toUpperCase(Locale.ENGLISH)));
                    }
                }
            }
            this.faceMatcher = faces::contains;
        } else {
            this.faceMatcher = Predicates.alwaysTrue();
        }
        this.weight = Integer.parseInt(properties.getProperty("weight", "0"));
        if (properties.containsKey("cbt_special_change_pack_if_loaded") && ConnectedBlockTextures.RESOURCE_PACK_PRIORITY_MAP.containsKey((Object)(packOverride = properties.getProperty("cbt_special_change_pack_if_loaded")))) {
            packName = packOverride;
        }
        this.packPriority = ConnectedBlockTextures.RESOURCE_PACK_PRIORITY_MAP.getInt((Object)packName);
        this.spriteProviderFactory = bakedModelFactory;
        this.tileProvider = TileProvider.load(properties, CBTUtil.directoryOf(location), manager);
        this.fileName = CBTUtil.fileNameOf(location);
    }

    @Override
    public int compareTo(CTMConfig other) {
        if (this.getResourcePackPriority() != other.getResourcePackPriority()) {
            return this.getResourcePackPriority() - other.getResourcePackPriority();
        }
        if (this.getWeight() != other.getWeight()) {
            return this.getWeight() - other.getWeight();
        }
        if (!this.getFileName().equals(other.getFileName())) {
            return this.getFileName().compareTo(other.getFileName());
        }
        return 0;
    }

    @Override
    public TileProvider getTileProvider() {
        return this.tileProvider;
    }

    @Override
    public Predicate<class_2960> getTileMatcher() {
        return this.tileMatcher;
    }

    @Override
    public Predicate<class_2350> getFaceMatcher() {
        return this.faceMatcher;
    }

    @Override
    public BiPredicate<class_1920, class_2338> getWorldConditions() {
        return this.worldConditions;
    }

    @Override
    public SpriteProvider createSpriteProvider(class_1058[] sprites) {
        return this.spriteProviderFactory.create(sprites, this.getSelf());
    }

    @Override
    public boolean affectsModel(class_1091 id, Supplier<Collection<class_4730>> textureDeps) {
        return !(!this.blockMatcher.test((class_2960)id) && !this.blockMatcher.test(CBTUtil.stripVariants(id)) || this.tileMatcher != null && !CBTUtil.mapAnyMatch(textureDeps.get(), class_4730::method_24147, this.tileMatcher));
    }

    @Override
    public int getResourcePackPriority() {
        return this.packPriority;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    protected abstract Self getSelf();

    @FunctionalInterface
    public static interface SpriteProviderFactory<C extends BaseCTMConfig<C>> {
        public SpriteProvider create(class_1058[] var1, C var2);
    }
}

