/*
 * Decompiled with CFR 0.152.
 */
package draylar.battletowers.entity.block;

import draylar.battletowers.api.Towers;
import draylar.battletowers.api.spawner.MobSpawnerEntryBuilder;
import draylar.battletowers.api.spawner.SpawnerManipulator;
import draylar.battletowers.api.tower.Floor;
import draylar.battletowers.registry.BattleTowerBlocks;
import draylar.battletowers.registry.BattleTowerEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3000;

public class ContentDeployerBlockEntity
extends class_2586
implements class_3000 {
    private static final int RADIUS = 8;
    private static final int MAX_CHESTS = 2;
    private static final int MAX_SPAWNERS = 2;
    private static final List<class_2338> CIRCULAR_POSITIONS = new ArrayList<class_2338>();
    private class_2960 floorID = new class_2960("minecraft", "empty");
    private boolean placeLadders = false;
    private boolean placeChests = false;
    private boolean placeSpawners = false;
    private boolean placeBossLock = false;
    private int delay = 0;

    public ContentDeployerBlockEntity() {
        super(BattleTowerEntities.CONTENT_DEPLOYER);
    }

    public void apply(Floor floor) {
        this.floorID = floor.getId();
        this.placeLadders = floor.placeLadders();
        this.placeChests = floor.placeChests();
        this.placeSpawners = floor.placeSpawners();
        this.placeBossLock = floor.placeBossLock();
    }

    public void method_16896() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            if (this.delay <= 20) {
                ++this.delay;
            } else {
                if (this.placeChests) {
                    this.placeChests();
                }
                if (this.placeSpawners) {
                    this.placeSpawners();
                }
                if (this.placeLadders) {
                    this.placeLadders();
                }
                if (this.placeBossLock) {
                    this.placeBossLock();
                } else {
                    this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
                    this.method_11012();
                }
            }
        }
    }

    private void placeBossLock() {
        this.field_11863.method_8652(this.field_11867, BattleTowerBlocks.BOSS_LOCK.method_9564(), 3);
    }

    private void placeLadders() {
        List randomDirections = Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166() != class_2350.class_2351.field_11052).collect(Collectors.toList());
        Collections.shuffle(randomDirections);
        class_2338 originPos = new class_2338(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
        for (int y = 0; y <= 1; ++y) {
            for (int i = 8; i >= 2; --i) {
                for (class_2350 direction2 : randomDirections) {
                    class_2338 wallPos = originPos.method_10079(direction2, i).method_10086(y);
                    class_2680 wallState = this.field_11863.method_8320(wallPos);
                    class_2338 innerPos = originPos.method_10079(direction2, i - 1).method_10086(y);
                    class_2680 innerState = this.field_11863.method_8320(innerPos);
                    if (!wallState.method_26206((class_1922)this.field_11863, wallPos, direction2.method_10153()) || !innerState.method_26215()) continue;
                    this.field_11863.method_8652(innerPos, BattleTowerBlocks.LADDER_DEPLOYER.method_9564(), 3);
                    return;
                }
            }
        }
    }

    private void placeChests() {
        ArrayList<class_2338> clonedPositions = new ArrayList<class_2338>(CIRCULAR_POSITIONS);
        Collections.shuffle(clonedPositions);
        int placedChests = 0;
        block0: for (class_2338 clonedPos : clonedPositions) {
            if (placedChests >= 2) {
                return;
            }
            for (int y = 0; y < 7; ++y) {
                class_2338 checkPos = this.field_11867.method_10081((class_2382)clonedPos).method_10086(y);
                class_2680 checkState = this.field_11863.method_8320(checkPos);
                class_2680 underState = this.field_11863.method_8320(checkPos.method_10074());
                if (!checkState.method_26215() || !underState.method_26212((class_1922)this.field_11863, checkPos.method_10074())) continue;
                boolean success = this.field_11863.method_8501(checkPos, class_2246.field_10034.method_9564());
                if (success) {
                    class_2595 chestBlockEntity = (class_2595)this.field_11863.method_8321(checkPos);
                    chestBlockEntity.method_11285(Towers.getLootTableFor(this.floorID), (long)this.field_11863.method_8409().nextInt(1000));
                }
                ++placedChests;
                continue block0;
            }
        }
        System.out.println("[Battle Towers] Couldn't place all chests in a layer. Was the tower overriden?");
    }

    private void placeSpawners() {
        ArrayList<class_2338> clonedPositions = new ArrayList<class_2338>(CIRCULAR_POSITIONS);
        Collections.shuffle(clonedPositions);
        int placedSpawners = 0;
        block0: for (class_2338 clonedPos : clonedPositions) {
            if (placedSpawners >= 2) {
                return;
            }
            for (int y = 0; y < 7; ++y) {
                class_2338 checkPos = this.field_11867.method_10081((class_2382)clonedPos).method_10086(y);
                class_2680 checkState = this.field_11863.method_8320(checkPos);
                class_2680 underState = this.field_11863.method_8320(checkPos.method_10074());
                if (!checkState.method_26215() || !underState.method_26212((class_1922)this.field_11863, checkPos.method_10074())) continue;
                boolean success = this.field_11863.method_8501(checkPos, class_2246.field_10260.method_9564());
                if (success) {
                    class_2636 mobSpawner = (class_2636)this.field_11863.method_8321(checkPos);
                    ((SpawnerManipulator)mobSpawner).setTowerSpawner(true);
                    mobSpawner.method_11390().method_8277(new MobSpawnerEntryBuilder(Towers.getSpawnerEntryFor(this.floorID)).build());
                }
                ++placedSpawners;
                continue block0;
            }
        }
        System.out.println("[Battle Towers] Couldn't place all spawners in a layer. Was the tower overriden?");
    }

    public class_2487 method_11007(class_2487 tag) {
        tag.method_10582("FloorID", this.floorID.toString());
        tag.method_10556("PlaceChests", this.placeChests);
        tag.method_10556("PlaceSpawners", this.placeSpawners);
        tag.method_10556("PlaceLadders", this.placeLadders);
        tag.method_10569("Delay", this.delay);
        return super.method_11007(tag);
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        this.floorID = new class_2960(tag.method_10558("FloorID"));
        this.placeChests = tag.method_10577("PlaceChests");
        this.placeSpawners = tag.method_10577("PlaceSpawners");
        this.placeLadders = tag.method_10577("PlaceLadders");
        this.delay = tag.method_10550("Delay");
        super.method_11014(state, tag);
    }

    static {
        for (int x = -8; x <= 8; ++x) {
            for (int z = -8; z <= 8; ++z) {
                double distance = Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
                if (!(distance <= 8.0) || x == 0 && z == 0) continue;
                CIRCULAR_POSITIONS.add(new class_2338(x, 0, z));
            }
        }
    }
}

