/*
 * Decompiled with CFR 0.152.
 */
package draylar.battletowers.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import draylar.battletowers.BattleTowers;
import draylar.battletowers.api.spawning.BiomeConditional;
import draylar.battletowers.api.tower.Floor;
import draylar.battletowers.api.tower.FloorCollection;
import draylar.battletowers.api.tower.Tower;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5468;
import robosky.structurehelpers.structure.pool.ElementRange;
import robosky.structurehelpers.structure.pool.ExtendedSinglePoolElement;
import robosky.structurehelpers.structure.processor.WeightedChanceProcessor;

public class Towers {
    private static final Random RAND = new Random();
    private static final class_2960 DEFAULT_LOOT_TABLE = new class_2960("battletowers", "default");
    private static final List<class_2960> DEFAULT_SPAWNERS = Arrays.asList(new class_2960("minecraft", "zombie"), new class_2960("minecraft", "skeleton"), new class_2960("minecraft", "spider"));
    public static final Map<BiomeConditional, Tower> BIOME_ENTRANCES = new HashMap<BiomeConditional, Tower>();
    private static final Map<class_2960, Floor> FLOOR_DATA = new HashMap<class_2960, Floor>();
    public static Tower DEFAULT_TOWER = null;

    public static void register(class_2960 id, Tower tower) {
        BIOME_ENTRANCES.put(tower.getBiomeConditional(), tower);
        ImmutableList<class_3491> processors = Towers.collectProcessors(tower);
        class_3785 startPool = Towers.initializeFloorCollection(tower, tower.getEntrances(), processors, BattleTowers.id(tower.getName() + "_entrances"), new class_2960("empty"));
        Towers.initializeFloorCollection(tower, tower.getLayers(), processors, BattleTowers.id(tower.getName() + "_outlines"), BattleTowers.id(tower.getName() + "_tops"));
        Towers.initializeFloorCollection(tower, tower.getRoofs(), processors, BattleTowers.id(tower.getName() + "_tops"), new class_2960("empty"));
        Towers.initializeFloorCollection(tower, tower.getBottoms(), processors, BattleTowers.id(tower.getName() + "_bottoms"), new class_2960("empty"));
        tower.setStartPool(startPool);
        if (tower.getExtraPools() != null) {
            tower.getExtraPools().forEach(extraPool -> {
                ArrayList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> elements = new ArrayList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>>();
                extraPool.getElements().forEach((identifier, integer) -> elements.add(Pair.of((Object)ExtendedSinglePoolElement.of((class_2960)identifier, (boolean)false, (ImmutableList)processors), (Object)integer)));
                Towers.registerPool(extraPool.getId(), extraPool.getTerminator() == null ? new class_2960("empty") : extraPool.getTerminator(), elements);
            });
        }
    }

    private static class_3785 initializeFloorCollection(Tower tower, FloorCollection collection, ImmutableList<class_3491> processors, class_2960 towerId, class_2960 terminators) {
        ArrayList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> elements = new ArrayList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>>();
        Towers.initializeFloors(tower, collection, elements, processors);
        return Towers.registerPool(towerId, terminators, elements);
    }

    private static ImmutableList<class_3491> collectProcessors(Tower tower) {
        WeightedChanceProcessor.Builder builder = WeightedChanceProcessor.builder();
        tower.getProcessors().forEach((inputId, weightedOutputIds) -> {
            class_2248 input = (class_2248)class_2378.field_11146.method_10223(inputId);
            weightedOutputIds.forEach(weightedOutput -> {
                int weight = weightedOutput.getWeight();
                if (class_2378.field_11146.method_10223(weightedOutput.getId()) != class_2246.field_10124 && weight > 0) {
                    builder.add(input, new WeightedChanceProcessor.Entry[]{WeightedChanceProcessor.Entry.of((class_2248)((class_2248)class_2378.field_11146.method_10223(weightedOutput.getId())), (float)weight)});
                }
            });
        });
        return ImmutableList.builder().add((Object)builder.build()).build();
    }

    private Towers() {
    }

    private static class_3785 registerPool(class_2960 id, class_2960 terminators, List<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> elements) {
        return class_5468.method_30600((class_3785)new class_3785(id, terminators, elements, class_3785.class_3786.field_16687));
    }

    private static void initializeFloors(Tower tower, FloorCollection floors, List<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> elements, ImmutableList<class_3491> processors) {
        floors.getFloors().forEach(floor -> {
            elements.add(Pair.of((Object)ExtendedSinglePoolElement.of((class_2960)floor.getId(), (boolean)false, (ImmutableList)processors), (Object)1));
            floors.applyDefaults((Floor)floor);
            FLOOR_DATA.put(floor.getId(), (Floor)floor);
            if (floor.getMaxSpawns() != 0 || floor.getMinSpawns() != 0) {
                int max = Math.max(floor.getMinSpawns(), floor.getMaxSpawns());
                tower.addLimit(ElementRange.of((class_2960)floor.getId(), (int)floor.getMinSpawns(), (int)(max == 0 ? 100 : Math.max(floor.getMinSpawns(), floor.getMaxSpawns()))));
            }
        });
    }

    public static Tower getTowerFor(class_1959 biome) {
        for (Map.Entry<BiomeConditional, Tower> conditional : BIOME_ENTRANCES.entrySet()) {
            if (!conditional.getKey().isValid(biome)) continue;
            return conditional.getValue();
        }
        return DEFAULT_TOWER;
    }

    public static class_2960 getSpawnerEntryFor(class_2960 floorID) {
        if (FLOOR_DATA.containsKey(floorID)) {
            List<class_2960> spawnerEntries = FLOOR_DATA.get(floorID).getEntities();
            if (spawnerEntries == null) {
                spawnerEntries = new ArrayList<class_2960>();
                spawnerEntries.add(new class_2960("minecraft:zombie"));
            }
            if (!spawnerEntries.isEmpty()) {
                return spawnerEntries.get(RAND.nextInt(spawnerEntries.size()));
            }
            System.out.println(String.format("[Battle Towers] floor %s's content provider has no valid spawners. Falling back to defaults.", floorID.toString()));
        } else {
            System.out.println(String.format("[Battle Towers] floor %s doesn't have a registered content provider. Falling back to defaults.", floorID.toString()));
        }
        return DEFAULT_SPAWNERS.get(RAND.nextInt(DEFAULT_SPAWNERS.size()));
    }

    public static class_2960 getLootTableFor(class_2960 floorID) {
        if (FLOOR_DATA.containsKey(floorID)) {
            List<class_2960> lootTables = FLOOR_DATA.get(floorID).getLootTables();
            if (lootTables == null) {
                lootTables = new ArrayList<class_2960>();
                lootTables.add(BattleTowers.id("default"));
            }
            if (!lootTables.isEmpty()) {
                return lootTables.get(RAND.nextInt(lootTables.size()));
            }
            System.out.println(String.format("[Battle Towers] floor %s's content provider has no valid loot tables. Falling back to defaults.", floorID.toString()));
        } else {
            System.out.println(String.format("[Battle Towers] floor %s doesn't have a registered content provider. Falling back to defaults.", floorID.toString()));
        }
        return DEFAULT_LOOT_TABLE;
    }

    public static Floor getFloor(class_2960 id) {
        return FLOOR_DATA.get(id);
    }
}

