/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mcupdater.Distribution;
import org.mcupdater.Library;
import org.mcupdater.PlatformType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DistributionParser {
    private static final String VERSION = "1.3";

    public static Document readXmlFromFile(File packFile) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(packFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document readXmlFromUrl(String serverUrl) throws Exception {
        URL server;
        try {
            server = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        URLConnection serverConn = server.openConnection();
        serverConn.setRequestProperty("User-Agent", "MCUpdater-Bootstrap/1.3");
        serverConn.setConnectTimeout(5000);
        serverConn.setReadTimeout(5000);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(serverConn.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Distribution parseDocument(Document dom, String distName, String javaVersion, PlatformType pt) {
        Element parent = dom.getDocumentElement();
        if (parent.getNodeName().equals("Distributions")) {
            System.out.println("Iterating defined distributions:");
            NodeList distributions = parent.getElementsByTagName("Distribution");
            for (int i = 0; i < distributions.getLength(); ++i) {
                Element docEle = (Element)distributions.item(i);
                System.out.println(docEle.getAttribute("name") + " - " + docEle.getElementsByTagName("FriendlyName").item(0).getTextContent());
                if (!docEle.getAttribute("name").equals(distName)) continue;
                NodeList versions = docEle.getElementsByTagName("JavaVersion");
                for (int verIndex = 0; verIndex < versions.getLength(); ++verIndex) {
                    System.out.println("--" + versions.item(verIndex).getTextContent());
                    if (!versions.item(verIndex).getTextContent().equals(javaVersion)) continue;
                    return DistributionParser.getDistribution(docEle, pt);
                }
            }
        } else {
            throw new RuntimeException("Malformed XML!");
        }
        return null;
    }

    private static String getTextValue(Element ele, String tagName) {
        Node node;
        Element el;
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (el = (Element)nl.item(0)) != null && (node = el.getFirstChild()) != null) {
            textVal = DistributionParser.unescapeXML(node.getNodeValue());
        }
        return textVal;
    }

    private static String unescapeXML(String nodeValue) {
        return nodeValue.replace("&amp;", "&").replace("&quot;", "\"").replace("&apos;", "'").replace("&lt;", "<").replace("&gt;", ">");
    }

    private static Distribution getDistribution(Element el, PlatformType pt) {
        String name = el.getAttribute("name");
        String friendlyName = DistributionParser.getTextValue(el, "FriendlyName");
        String javaVersion = DistributionParser.getTextValue(el, "JavaVersion");
        String mainClass = DistributionParser.getTextValue(el, "Class");
        String params = DistributionParser.getTextValue(el, "Params");
        ArrayList<Library> libraries = new ArrayList<Library>();
        NodeList nl = el.getElementsByTagName("Library");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elLib = (Element)nl.item(i);
            Library l = DistributionParser.getLibrary(elLib, pt);
            if (l == null) continue;
            libraries.add(l);
        }
        return new Distribution(name, friendlyName, javaVersion, mainClass, params, libraries);
    }

    private static Library getLibrary(Element el, PlatformType pt) {
        boolean validOnPlatform = false;
        NodeList platforms = el.getElementsByTagName("Platform");
        for (int i = 0; i < platforms.getLength(); ++i) {
            if (!platforms.item(i).getTextContent().equals(pt.toString())) continue;
            validOnPlatform = true;
            break;
        }
        if (!validOnPlatform) {
            return null;
        }
        String name = el.getAttribute("name");
        String filename = DistributionParser.getTextValue(el, "Filename");
        long size = Long.parseLong(DistributionParser.getTextValue(el, "Size"));
        String md5 = DistributionParser.getTextValue(el, "MD5");
        ArrayList<URL> downloadURLs = new ArrayList<URL>();
        NodeList nl = el.getElementsByTagName("DownloadURL");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elURL = (Element)nl.item(i);
            try {
                URL dlURL = new URL(elURL.getTextContent());
                downloadURLs.add(dlURL);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Library(name, filename, size, md5, pt.toString(), downloadURLs);
    }

    public static Distribution loadFromFile(File packFile, String distName, String javaVersion, PlatformType pt) {
        try {
            return DistributionParser.parseDocument(DistributionParser.readXmlFromFile(packFile), distName, javaVersion, pt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Distribution loadFromURL(String serverUrl, String distName, String javaVersion, PlatformType pt) {
        try {
            return DistributionParser.parseDocument(DistributionParser.readXmlFromUrl(serverUrl), distName, javaVersion, pt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

