/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mcupdater.Distribution;
import org.mcupdater.DistributionParser;
import org.mcupdater.Library;
import org.mcupdater.PlatformType;
import org.mcupdater.downloadlib.DownloadQueue;
import org.mcupdater.downloadlib.Downloadable;
import org.mcupdater.downloadlib.TrackerListener;

public class BootstrapForm
extends JWindow
implements TrackerListener {
    private static final ResourceBundle config = ResourceBundle.getBundle("config");
    private static final long serialVersionUID = 1L;
    private static String bootstrapUrl;
    private static String distribution;
    private static String localBootstrap;
    private final JProgressBar progressBar;
    private final JLabel lblStatus;
    private Distribution distro;
    private static File basePath;
    private static PlatformType thisPlatform;
    private String[] passthroughParams;
    private static String defaultPack;
    protected static BootstrapForm frame;
    private static boolean debug;

    public static void main(String[] args) {
        System.out.println("MCUpdater Bootstrap 1.3");
        System.setProperty("java.net.preferIPv4Stack", "true");
        OptionParser optParser = new OptionParser();
        optParser.allowsUnrecognizedOptions();
        optParser.accepts("help", "Show help").forHelp();
        optParser.formatHelpWith(new BuiltinHelpFormatter(160, 3));
        ArgumentAcceptingOptionSpec<String> bootstrapSpec = optParser.accepts("bootstrap", "Bootstrap URL").withRequiredArg().ofType(String.class).defaultsTo(config.getString("bootstrapURL"), (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> localBootstrapSpec = optParser.accepts("bootstrapfile", "Bootstrap from local XML").withRequiredArg().ofType(String.class).defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> distSpec = optParser.accepts("distribution", "MCUpdater distribution").withRequiredArg().ofType(String.class).defaultsTo(config.getString("distribution"), (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> defaultpackSpec = optParser.accepts("defaultpack", "Default pack URL").withRequiredArg().ofType(String.class).defaultsTo(config.getString("defaultPack"), (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rootSpec = optParser.accepts("MCURoot", "Custom folder for MCUpdater").withRequiredArg().ofType(String.class).defaultsTo(config.getString("customPath"), (String[])new String[0]);
        final NonOptionArgumentSpec<String> nonOpts = optParser.nonOptions();
        optParser.accepts("debug", "Show console output from MCUpdater");
        final OptionSet options = optParser.parse(args);
        defaultPack = options.valueOf(defaultpackSpec);
        if (options.has("debug")) {
            debug = true;
        }
        if (options.has("help")) {
            try {
                optParser.printHelpOn(System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        bootstrapUrl = (String)bootstrapSpec.value(options);
        localBootstrap = (String)localBootstrapSpec.value(options);
        distribution = (String)distSpec.value(options);
        String customPath = options.valueOf(rootSpec);
        if (System.getProperty("os.name").startsWith("Windows")) {
            basePath = new File(new File(System.getenv("APPDATA")), ".MCUpdater");
            thisPlatform = PlatformType.valueOf("WINDOWS" + System.getProperty("sun.arch.data.model"));
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            basePath = new File(new File(new File(new File(System.getProperty("user.home")), "Library"), "Application Support"), "MCUpdater");
            thisPlatform = PlatformType.valueOf("OSX64");
        } else {
            basePath = new File(new File(System.getProperty("user.home")), ".MCUpdater");
            thisPlatform = PlatformType.valueOf("LINUX" + System.getProperty("sun.arch.data.model"));
        }
        if (!customPath.isEmpty()) {
            basePath = new File(customPath);
        }
        final HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("bootstrapURL", options.valueOf(bootstrapSpec));
        opts.put("distribution", options.valueOf(distSpec));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                    if (UIManager.getLookAndFeel().getName().equals("Metal")) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    frame = new BootstrapForm();
                    ArrayList<Object> passthrough = new ArrayList<Object>();
                    passthrough.addAll(options.valuesOf(nonOpts));
                    passthrough.addAll(Arrays.asList(config.getString("passthroughArgs").split(" ")));
                    frame.setPassthroughParams(passthrough.toArray(new String[passthrough.size()]));
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                    frame.doWork(opts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setPassthroughParams(String[] args) {
        this.passthroughParams = args;
    }

    protected void doWork(Map<String, Object> opts) {
        System.out.println("System.getProperty('os.name') == '" + System.getProperty("os.name") + "'");
        System.out.println("System.getProperty('os.version') == '" + System.getProperty("os.version") + "'");
        System.out.println("System.getProperty('os.arch') == '" + System.getProperty("os.arch") + "'");
        System.out.println("System.getProperty('java.version') == '" + System.getProperty("java.version") + "'");
        System.out.println("System.getProperty('java.vendor') == '" + System.getProperty("java.vendor") + "'");
        System.out.println("System.getProperty('sun.arch.data.model') == '" + System.getProperty("sun.arch.data.model") + "'");
        if (localBootstrap.isEmpty()) {
            this.distro = DistributionParser.loadFromURL(bootstrapUrl, distribution, System.getProperty("java.version").substring(0, 3), thisPlatform);
            if (this.distro != null) {
                try {
                    FileUtils.copyURLToFile(new URL(bootstrapUrl), new File(basePath, "Bootstrap-cache.xml"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.print("Warning! No distribution was found via URL. Attempting to use cache.");
                this.distro = DistributionParser.loadFromFile(new File(basePath, "Bootstrap-cache.xml"), distribution, System.getProperty("java.version").substring(0, 3), thisPlatform);
            }
        } else {
            this.distro = DistributionParser.loadFromFile(new File(localBootstrap), distribution, System.getProperty("java.version").substring(0, 3), thisPlatform);
        }
        if (this.distro == null) {
            JOptionPane.showMessageDialog(this, "No configuration found that matches distribution \"" + opts.get("distribution") + "\" and Java " + System.getProperty("java.version").substring(0, 3), "MCU-Bootstrap. Make sure you are connected to the internet!", 0);
            System.exit(-1);
        }
        this.lblStatus.setText("Downloading " + this.distro.getFriendlyName());
        ArrayList<Downloadable> dl = new ArrayList<Downloadable>();
        for (Library l : this.distro.getLibraries()) {
            Downloadable dlEntry = new Downloadable(l.getName(), l.getFilename(), l.getMd5(), l.getSize(), l.getDownloadURLs());
            dl.add(dlEntry);
        }
        DownloadQueue queue = new DownloadQueue("Bootstrap", "Bootstrap", this, dl, new File(basePath, "lib"), null);
        queue.processQueue(new ThreadPoolExecutor(0, 1, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public BootstrapForm() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(contentPane);
        JPanel progressPanel = new JPanel();
        progressPanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        contentPane.add((Component)progressPanel, "South");
        progressPanel.setLayout(new BorderLayout(0, 0));
        JPanel primaryProgress = new JPanel();
        progressPanel.add((Component)primaryProgress, "Center");
        primaryProgress.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(10000);
        primaryProgress.add((Component)this.progressBar, "Center");
        this.lblStatus = new JLabel();
        primaryProgress.add((Component)this.lblStatus, "South");
        JPanel logoPanel = new JPanel(){
            private static final long serialVersionUID = 8686753828984892019L;
            final ImageIcon image = new ImageIcon(BootstrapForm.class.getResource("/bg_main.png"));

            @Override
            protected void paintComponent(Graphics g) {
                Image source = this.image.getImage();
                int w = source.getWidth(null);
                int h = source.getHeight(null);
                BufferedImage image = new BufferedImage(w, h, 2);
                Graphics2D g2d = (Graphics2D)image.getGraphics();
                g2d.drawImage(source, 0, 0, null);
                g2d.dispose();
                int width = this.getWidth();
                int height = this.getHeight();
                int imageW = image.getWidth(this);
                int imageH = image.getHeight(this);
                for (int x = 0; x < width; x += imageW) {
                    for (int y = 0; y < height; y += imageH) {
                        g.drawImage(image, x, y, this);
                    }
                }
            }
        };
        contentPane.add((Component)logoPanel, "Center");
        logoPanel.setLayout(new BorderLayout(0, 0));
        JLabel lblLogo = new JLabel("");
        lblLogo.setHorizontalAlignment(0);
        lblLogo.setIcon(new ImageIcon(BootstrapForm.class.getResource("/mcu-logo-new.png")));
        logoPanel.add((Component)lblLogo, "Center");
        this.setSize(480, 250);
    }

    @Override
    public void onQueueFinished(DownloadQueue queue) {
        if (queue.getFailedFileCount() > 0) {
            this.lblStatus.setText("Failed!");
            StringBuilder msg = new StringBuilder("Failed to download:\n");
            for (Downloadable entry : queue.getFailures()) {
                msg.append("   ").append(entry.getFilename()).append("\n");
            }
            JOptionPane.showMessageDialog(this, msg.toString(), "MCU-Bootstrap", 0);
            System.exit(-2);
        } else {
            this.lblStatus.setText("Finished!");
            StringBuilder sbClassPath = new StringBuilder();
            if (System.getProperty("os.name").startsWith("Mac")) {
                sbClassPath.append(File.pathSeparator).append(".");
            }
            for (Library lib : this.distro.getLibraries()) {
                if (!lib.getFilename().endsWith("jar")) continue;
                sbClassPath.append(File.pathSeparator).append(new File(new File(basePath, "lib"), lib.getFilename()).getAbsolutePath());
            }
            sbClassPath.append(File.pathSeparator).append(System.getProperty("java.home")).append(File.separator).append("lib/jfxrt.jar");
            try {
                String javaBin = "java";
                File binDir = System.getProperty("os.name").startsWith("Mac") ? new File(new File(System.getProperty("java.home")), "Commands") : new File(new File(System.getProperty("java.home")), "bin");
                if (binDir.exists()) {
                    javaBin = new File(binDir, "java").getAbsolutePath();
                }
                ArrayList<String> args = new ArrayList<String>();
                args.add(javaBin);
                args.add("-Djavafx.verbose=true");
                if (System.getProperty("os.name").toUpperCase().equals("MAC OS X")) {
                    args.add("-Xdock:name=" + this.distro.getFriendlyName());
                    args.add("-Xdock:icon=" + new File(new File(basePath, "lib"), "mcu-icon.icns").getAbsolutePath());
                }
                args.add("-cp");
                args.add(sbClassPath.toString().substring(1));
                args.add(this.distro.getMainClass());
                HashMap<String, String> fields = new HashMap<String, String>();
                StrSubstitutor fieldReplacer = new StrSubstitutor(fields);
                fields.put("defaultPack", defaultPack);
                fields.put("MCURoot", basePath.getAbsolutePath());
                if (this.distro.getParams() != null) {
                    String[] fieldArr = this.distro.getParams().split(" ");
                    for (int i = 0; i < fieldArr.length; ++i) {
                        fieldArr[i] = fieldReplacer.replace(fieldArr[i]);
                    }
                    args.addAll(Arrays.asList(fieldArr));
                }
                args.addAll(Arrays.asList(this.passthroughParams));
                String[] params = args.toArray(new String[args.size()]);
                if (!debug) {
                    Process p = Runtime.getRuntime().exec(params);
                    if (p != null) {
                        Thread.sleep(5000L);
                        System.exit(0);
                    }
                } else {
                    for (String s : args) {
                        System.out.print((s.contains(" ") ? "\"" + s + "\"" : s) + " ");
                    }
                    System.out.print("\n");
                    ProcessBuilder pb = new ProcessBuilder(params);
                    pb.redirectErrorStream(true);
                    Process p = pb.start();
                    Thread.sleep(2000L);
                    frame.setVisible(false);
                    if (p != null) {
                        String line;
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((line = input.readLine()) != null) {
                            System.out.println(line);
                        }
                        System.exit(0);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onQueueProgress(DownloadQueue queue) {
        this.lblStatus.setText("Downloading: " + queue.getName());
        this.progressBar.setValue((int)(queue.getProgress() * 10000.0f));
    }

    @Override
    public void printMessage(String msg) {
        System.out.println(msg);
    }

    static {
        debug = false;
    }
}

